<?LassoScript

	// This page creates a new poll.
	//
	// If the page is called without an action it displays an empty form for a new poll.
	// If the page is called with an action of 'create' it creates a new records in the
	// polls database.
	
	// Store the action in a variable
	var: 'action' = (action_param: 'action');
	
	// Create an empty variable to hold the preference map
	var: 'poll_prefs' = map;
	
	// Check the action
	if: ($action >> 'create');
	
		// Store the preferences in the preference map
		
		var: 'poll_prefs' = (map);		
		iterate: action_params, (var: 'temp');
			var: 'key' = $temp->first;
			var: 'value' = $temp->second;
			if: $key->(beginswith: 'prefs_');
				$key -= 'prefs_';
				$poll_prefs->(insert: $key = $value);
			/if;
		/iterate;
		
		// If the user has chosen to make this the current poll then all of the
		// other polls need to be updated so there is only one current poll.
		
		if: (action_param: 'poll_current') == 'true';
			var: 'poll_current' = 'true';
			inline: -log=$log_level,
					-update,
					-database='op_quick_poll', 
					-table='polls',
					-keyfield='current',
					-keyvalue='true',
					'current'='false',
					-maxrecords='0';
			/inline;
		else;
			var: 'poll_current' = 'false';
		/if;
		
		// Add the record to the polls table.  If no error occurred then the user is
		// redirected to the edit page for the poll that was just added.  The top-level
		// error page will handle displaying the error if one occurred.
		// Most of the values come from action parameters.
		// The poll preferences are stored as a serizlied map.
		
		inline: -log=$log_level,
				-add,
				-database='op_quick_poll', 
				-table='polls',
				-keyfield='id',
				'title'=(action_param: 'poll_title'),
				'code'=(action_param: 'poll_code'),
				'status'=(action_param: 'poll_status'),
				'archive'='true',
				'current'=$poll_current,
				'question'=(action_param: 'poll_question'),
				'results'=(action_param: 'poll_results'),
				'display'=(action_param: 'poll_display'),
				'frequency'=(action_param: 'poll_frequency'),
				'prefs'=$poll_prefs->serialize->trim &;
			if: (error_msg == error_noerror);
				redirect_url: response_filepath + '?poll=' + keyfield_value + '&amp;mode=edit';
			/if;
		/inline;
		
	else: ($action !>> 'cancel');
	
		// If the action is NOT cancel or create then we set the handled variable
		// to true so that the remainder of this page displays.  If the action was
		// cancel then handled will be set to false and the default listing page
		// will display
		
		var: 'handled' = true;
	
	/if;	
		
	// Define a helper tag [colorPicker].  This tag outputs a checkbox with a clickable 
	// label which allows a new color to be chosen.  By defining this custom tag the code
	// for each of the checkboxes can be modified in one place.
	
	var: 'colorPicker_id' = 0;
	define_tag: 'colorPicker', -required='name', -required='label';
		$colorPicker_id++;
		local: 'output' = '<input type="checkbox" name="prefs_' + #name + '" id="colorPicker_' + $colorPicker_id + '" value="' + $poll_prefs->(find: #name) + '" /> <a href="" onclick="return stylePicker(this,\'colorPicker_' + $colorPicker_id + '\',\'Type a color name or hex value:\',\'color\');"' + (($poll_prefs->keys >> #name)?' style="color: ' + $poll_prefs->(find: #name) + ';"') + '>' + #label + '</a>';
		return: @#output;
	/define_tag;

?>
[if: $handled == true]
	<h2>Lasso Quick Poll</h2>
	<div class="group_list" id="page_frame"[if: (var: 'ljax') == true] xmlns="http://www.w3.org/1999/xhtml"[/if]>
		<div class="group"><b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>
			<div class="group_title">
				<a href="[response_filepath]">Home</a> >
				New Poll
			</div>
			<form action="index.lasso" method="post">
				<div class="item">
					<input type="hidden" name="poll" value="new" />
					<table>
						<tr>
							<th>Title:</th>
							<td>
								<input type="text" name="poll_title" value="New Poll" />
								[colorPicker: 'display_title_color','Text Color']
								[colorPicker: 'display_title_background','Background']
							</td>
						</tr>
						<tr>
							<th>Visibility:</th>
							<td>
								<select name="poll_status">
									<option value="true" selected="selected">Show</option>
									<option value="false">Hide</option>
								</select>
							</td>
						</tr>
						<tr>
							<th>Code:</th>
							<td>
								<input type="text" name="poll_code" value="[var: 'poll_code']" />
								<input type="checkbox" name="poll_current" value="true" />
								Current
							</td>
						</tr>
						<tr>
							<th>Question:</th>
							<td><textarea name="poll_question" cols="40" rows="4"></textarea></td>
						</tr>
						<tr>
							<th>Style:</th>
							<td>
								[colorPicker: 'display_color','Default Text Color']
								[colorPicker: 'display_background','Poll Background']
							</td>
						</tr>
					[loop: 10]
						[var: 'loop_count' = loop_count]
						<tr[if: (loop_count > 1)] style="display: none" id="new[loop_count]"[/if]>
							<th>[if: (loop_count == 1)]Answers:[/if]</th>
							<td>
								<input type="hidden" name="answers" value="new[loop_count]" />
								<input type="text" name="answers_new[loop_count]_answer" value="" onchange="var temp = document.getElementById('new[loop_count + 1]'); if (temp && temp.style && temp.style.display) temp.style.display = 'visible';" />
								<input type="hidden" name="answers_new[loop_count]_sort" value="[loop_count]" />
							</td>
						</tr>
					[/loop]
						<tr>
							<th>Display Message:</th>
							<td>
								<textarea name="poll_display" cols="40" rows="2"></textarea>
							</td>
						</tr>
						<tr>
							<th>Results Message:</th>
							<td>
								<textarea name="poll_results" cols="40" rows="2"></textarea>
							</td>
						</tr>
						<tr>
							<th>Frequency:</th>
							<td>Allow each user to vote: <select name="poll_frequency">
								<option value="once">Once</option>
								<option value="hour">Hourly</option>
								<option value="day" selected="selected">Daily</option>
								<option value="month">Monthly</option>
							</select></td>
						</tr>
						<tr>
							<th></th>
							<td>
								<input type="submit" name="action" value="Create" />
								<input type="submit" name="action" value="Cancel" />
							</td>
						</tr>
					</table>
					<br />
				</div>
			</form>
		</div>
		<div class="group">
			<div class="group_title"><a href="index.lasso">List Polls</a></div>
		</div>
	</div>
[/if]